#include "tmr0.h"

void tmr0Init(void){    
    //setup for counting on T0CKI
    OPTION_REGbits.TMR0CS=1;    //counter mode
    OPTION_REGbits.PSA=1;       //don't use prescaler
    //OPTION_REGbits.PS=0;        //prescaler=2
    TMR0=0;                     //reset    
    TMR0IE=1;                   //use interrupt
    t_msb=0;
    /*
    TMR2IE=0;
    TMR2IF=0;    
    T2CON=0;    //reset    
    PR2=0xFF;   //max count
    TMR2=0;     //reset counter
    T2CONbits.T2CKPS=3;     //PS=64 => 488Hz
    //T2CONbits.T2CKPS=2;     //PS=16 => 1953Hz
    //T2CONbits.T2CKPS=1;     //PS=4 => 7812Hz
    //T2CONbits.T2CKPS=0;     //PS=1 => 31250Hz
    T2CONbits.TMR2ON=1;
    PEIE=1;
    TMR2IE=1;        

*/
}

unsigned int get16tmr(void){    //get 16bit extended value of TMR0 and reset
    unsigned int v;
    //unsigned char option
    unsigned char t;
    //option=OPTION_REG;          //save register
    GIE=0;                      //turn off interrupts
    t=TMR0;                     //save t ASAP
    TMR0=0;
    v=(t_msb<<8)|t;
    t_msb=0;
    GIE=1;                      //restoring OPTION_REG doesn't seem to work
    return v;
}

void tmr0int(void){             //called on interrupt
    t_msb++;
}
